/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.brackets;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.OperatorType;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.CallStaticExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.lexer.ZSTokenType;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.expression.ParsedExpressionBinary;
import org.openzen.zenscript.parser.expression.ParsedExpressionString;

public class ValidatedEscapableBracketParser
implements BracketExpressionParser {
    private final FunctionalMemberRef method;
    private final Method validationMethod;
    private final String name;
    private final DefinitionTypeID targetType;

    public ValidatedEscapableBracketParser(String name, FunctionalMemberRef parserMethod, Method validationMethod, GlobalTypeRegistry registry) {
        this.method = parserMethod;
        this.validationMethod = validationMethod;
        this.name = name;
        this.targetType = registry.getForDefinition(parserMethod.getTarget().definition, new TypeID[0]);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        StringBuilder string = new StringBuilder();
        ArrayList<ParsedExpression> expressionList = new ArrayList<ParsedExpression>();
        while (tokens.optional(ZSTokenType.T_GREATER) == null) {
            ZSToken next = (ZSToken)tokens.next();
            if (next.type != ZSTokenType.T_DOLLAR) {
                string.append(next.content);
                string.append(tokens.getLastWhitespace());
                continue;
            }
            String ws = tokens.getLastWhitespace();
            if (!ws.isEmpty()) {
                string.append(next.content).append(ws);
                continue;
            }
            next = (ZSToken)tokens.next();
            if (next.type == ZSTokenType.T_AOPEN) {
                if (string.length() != 0) {
                    expressionList.add(new ParsedExpressionString(position, string.toString(), false));
                    string = new StringBuilder();
                }
                expressionList.add(ParsedExpression.parse(tokens));
                tokens.required(ZSTokenType.T_ACLOSE, "} expected.");
                string.append(tokens.getLastWhitespace());
                continue;
            }
            string.append("$").append(ws);
            string.append(next.content).append(tokens.getLastWhitespace());
        }
        if (string.length() != 0) {
            expressionList.add(new ParsedExpressionString(position, string.toString(), false));
        }
        if (expressionList.isEmpty()) {
            expressionList.add(new ParsedExpressionString(position, "", false));
        }
        if (expressionList.size() == 1) {
            ParsedExpression parsedExpression = (ParsedExpression)expressionList.get(0);
            if (this.validationMethod != null && parsedExpression instanceof ParsedExpressionString) {
                boolean valid;
                String value = ((ParsedExpressionString)parsedExpression).value;
                try {
                    valid = (Boolean)this.validationMethod.invoke(null, value);
                }
                catch (Exception e) {
                    String message = String.format("Invalid parameters to BEP %s: '<%s:%s>", this.name, this.name, value);
                    throw new ParseException(position, message, e);
                }
                if (!valid) {
                    String format = String.format("Invalid parameters to BEP %s: '<%s:%s>. There may be more information about this in the log.", this.name, this.name, value);
                    throw new ParseException(position, format);
                }
            }
        }
        return new StaticMethodCallExpression(position, expressionList);
    }

    private class StaticMethodCallExpression
    extends ParsedExpression {
        private final ParsedExpression call;

        public StaticMethodCallExpression(CodePosition position, List<ParsedExpression> expressions) {
            super(position);
            ParsedExpression p = null;
            for (ParsedExpression expression : expressions) {
                p = p == null ? expression : new ParsedExpressionBinary(expression.position, p, expression, OperatorType.ADD);
            }
            this.call = p;
        }

        @Override
        public IPartialExpression compile(ExpressionScope scope) throws CompileException {
            Expression methodCall = this.call.compile(scope.withHint(BasicTypeID.STRING)).eval();
            CallArguments arguments = new CallArguments(methodCall);
            return new CallStaticExpression(this.position, ValidatedEscapableBracketParser.this.targetType, ValidatedEscapableBracketParser.this.method, ValidatedEscapableBracketParser.this.method.getHeader(), arguments);
        }

        @Override
        public boolean hasStrongType() {
            return true;
        }
    }
}

